IF EXISTS(SELECT * FROM SYS.procedures WHERE  NAME = 'P_MEDIAF_CALCULAR_LANCAMENTOS_FILIAL')
	BEGIN
		DROP PROCEDURE P_MEDIAF_CALCULAR_LANCAMENTOS_FILIAL;
	END;
GO
 
/****** Object:  StoredProcedure [dbo].[P_MEDIAF_CALCULAR_LANCAMENTOS_FILIAL]    Script Date: 03/09/2014 11:21:39 ******/

SET ANSI_NULLS ON;

SET QUOTED_IDENTIFIER ON;
GO
--EXECUTE P_MEDIAF_CALCULAR_LANCAMENTOS_FILIAL 1,1,1,0

/*

=======================================================================================
'Job.................: Itec - Medias de venda - Step 4 - Média P - Calcular lancamentos
'Função..............: 
'Objetivo............: Calcular MediaF de casos apenas com media prevista  
'Tabelas.............: EST_PROD_CPL_DEMANDA_PROC | EST_PROD_CPL_DEMANDA_PROC_CPL
'Dt Modificação......: 29/08/2023
'Modificação.........: Tag #A002 - Ajuste no cálculo do mês 3
'=======================================================================================
Tag #A001 - Alteração do codigo  
Tag #I001 - Inclusão de novo codigo 
Tag #A002 - Possibilitar Calculo de Media do mês 3, caso o produto tenha VENDA no mês e SOMENTE se o mesmo tiver pelo menos 3 meses de nascimento.

*/
CREATE PROCEDURE [dbo].[P_MEDIAF_CALCULAR_LANCAMENTOS_FILIAL] @CD_EMP    INT = 1
															, @CD_FILIAL INT
															, @CD_USU    INT = 1
															, @CONSULTA  INT = 0
AS
	 BEGIN
	 --Calcular parmetros de datas
		 SET CONTEXT_INFO 0x66666;
		 DECLARE @DT_INI                      DATETIME
			   , @DT_FIM                      DATETIME
			   , @AGORA                       DATETIME
			   , @QT_DIAS_VALID_FALTA_CRONICA INT      = 0
			   , @ANO_MES0                    INT
			   , @ANO_MES1                    INT
			   , @ANO_MES2                    INT
			   , @ANO_MES3                    INT
			   , @INICIO_MEDIAP_IMEDIATO	  tinyint=0;

		 SELECT
				@DT_FIM = DBO.F_ONTEM() --Dia anterior
			  , @DT_INI = DATEADD(day, -29, @DT_FIM) --1 ms e 1 dia atrs
			  , @AGORA = CONVERT(CHAR(10), GETDATE(), 112)
			  , @ANO_MES0 = CONVERT(CHAR(6), @DT_FIM, 112) --esse ms
			  , @ANO_MES1 = CONVERT(CHAR(6), DATEADD(MONTH, -1, @DT_FIM), 112) --ms anterior
			  , @ANO_MES2 = CONVERT(CHAR(6), DATEADD(MONTH, -2, @DT_FIM), 112) --2 meses atrs
			  , @ANO_MES3 = CONVERT(CHAR(6), DATEADD(MONTH, -3, @DT_FIM), 112);
		 
		DECLARE @CD_CURVA_PD INT 
	
		SET @CD_CURVA_PD =(SELECT CD_CURVA_PD FROM PRC_EMP WHERE CD_EMP = @CD_EMP);
			 
		SET @QT_DIAS_VALID_FALTA_CRONICA = ISNULL((SELECT VALOR
																FROM
																	PRC_EMP_CONFIG
																WHERE  CD_CHAVE = 'QTDE_DIAS_VALIDADE_MEDIAP_FALTA_CRONICA'
															), 0);
															
															
		SET @INICIO_MEDIAP_IMEDIATO = ISNULL((SELECT VALOR FROM PRC_EMP_CONFIG WHERE  CD_CHAVE = 'INICIA_IMEDIATO_CALC_PRODUTO_MEDIAP'), 0);

		SET NOCOUNT ON; 

	 --Média P - Zerar vencidos
		 PRINT 'P_MEDIAF_CALCULAR_LANCAMENTOS_FILIAL - UPDATE 1 '+CONVERT(VARCHAR, GETDATE(), 108);
		
		UPDATE p
		   SET
			   p.QTDE_MEDIAP = 0
			 , p.CD_USU = 1
			 , DT_ULT_ALT = GETDATE()
		 FROM   EST_PROD_CPL_MEDIAP p
				INNER JOIN EST_PROD_CPL_NASC ON p.CD_EMP = EST_PROD_CPL_NASC.CD_EMP
												AND p.CD_FILIAL = EST_PROD_CPL_NASC.CD_FILIAL
												AND p.CD_PROD = EST_PROD_CPL_NASC.CD_PROD
		 WHERE
			   EST_PROD_CPL_NASC.QTDE_MES_VENDA_FECHADO > 2
			   AND p.QTDE_MEDIAP > 0
			   AND p.cd_emp = @CD_EMP
			   AND p.cd_filial = @CD_FILIAL;

	--Zerar mediap falta cronica vencida
		 IF @QT_DIAS_VALID_FALTA_CRONICA > 0
			 BEGIN
				 PRINT 'UPDATE 2 '+CONVERT(VARCHAR, GETDATE(), 108);
				 UPDATE p
				   SET
					   p.QTDE_MEDIAP = 0
					 , p.CD_USU = 1
					 , FALTA_CRONICA = 0
					 , DT_ULT_ALT = GETDATE()
				 FROM   EST_PROD_CPL_MEDIAP p
				 WHERE
					   FALTA_CRONICA = 1
					   AND p.QTDE_MEDIAP > 0
					   AND DATEADD(DAY, @QT_DIAS_VALID_FALTA_CRONICA, (P.DT_CAD)) < CONVERT(DATE, GETDATE())
					   AND p.cd_emp = @CD_EMP
					   AND p.cd_filial = @CD_FILIAL;
			 END;
	
/***********************************************************************************************************************************************/
		 --tabela temporria que conter a base do clculo
		 CREATE TABLE #RS_PROD(CD_FILIAL              INT
								, CD_PROD                INT
								, P1                     MONEY
								, P2                     MONEY
								, PPV                    MONEY
								, MEDIAP                 MONEY
								, QT_IT_ATUAL            MONEY
								, QT_IT_MES1             MONEY
								, QT_IT_MES2             MONEY
								, QT_IT_MES3             MONEY
								, QT_IT_ATUAL_GRV        MONEY
								, QT_IT_MES1_GRV         MONEY
								, QT_IT_MES2_GRV         MONEY
								, QT_IT_MES3_GRV         MONEY
								, MEDIA3M                MONEY
								, SAZ                    INT
								, LIMITP AS MEDIA3M + (MEDIA3M * (PPV / 100.0000))
								, LIMITV AS MEDIA3M - (MEDIA3M * (PPV / 100.0000))
								, DT_NASC                DATETIME
								, DIAS_NASC AS (DATEDIFF(day, [DT_NASC], GETDATE()))
								, QTDE_MES_VENDA_FECHADO INT
								, PRIMARY KEY(CD_PROD, CD_FILIAL)
								);

		 CREATE TABLE #RS_PROD_P (CD_EMP                 INT
									, CD_FILIAL              INT
									, CD_PROD                INT
									, QTDE_MEDIAP            MONEY
									, DT_NASC                DATETIME
									, QTDE_MES_VENDA_FECHADO INT
									, DIAS_NASC              INT
									, P1                     MONEY
									, P2                     MONEY
									, PPV                    MONEY
									, CD_GRP_PARAM			 INT
									, TP_GRUPO_PARAMETRO     INT
									, PRIMARY KEY(CD_EMP, CD_PROD, CD_FILIAL)
									);
/***********************************************************************************************************************************************/
-- Gera Data de nascimento para produto sem nascimento,. mas com estoque >0
/***********************************************************************************************************************************************/
	INSERT INTO EST_PROD_CPL_NASC (CD_EMP,CD_FILIAL,CD_PROD,DT_NASC,MEDIA_F_LIBERADA,QTDE_MES_VENDA_FECHADO)
	SELECT
		   P.CD_EMP
		 , P.CD_FILIAL
		 , P.CD_PROD
		 ,  CONVERT(date,getdate() )  DT_NASC
		 , 0 MEDIA_F_LIBERADA
		 , 0 QTDE_MES_VENDA_FECHADO
	FROM
		 EST_PROD_CPL_MEDIAP P
		 JOIN EST_PROD_CPL_MEDIAF F ON F.CD_EMP = P.CD_EMP
									   AND F.CD_FILIAL = P.CD_FILIAL
									   AND F.CD_PROD = P.CD_PROD
		 LEFT JOIN EST_PROD_CPL_NASC n ON     p.CD_EMP = n.CD_EMP
										  AND p.CD_FILIAL = n.CD_FILIAL
										  AND p.CD_PROD = n.CD_PROD
		 JOIN EST_PROD_CPL C ON F.CD_EMP = C.CD_EMP
								AND F.CD_FILIAL = C.CD_FILIAL
								AND F.CD_PROD = C.CD_PROD
	WHERE     P.CD_EMP = 1
		  AND P.CD_FILIAL = @CD_FILIAL
		  AND C.QT_EST > 0
		  AND NOT F.CD_FILIAL IN(SELECT CD_FILIAL FROM PRC_FILIAL_DEPOSITO)
		  AND N.CD_EMP IS NULL;

/***********************************************************************************************************************************************/
-- ZERANDO LIXOS DE MEDIAF - Produto sem mediap e sem data de nascimento, mas com mediaf. e filial nao DEPOSITO
/***********************************************************************************************************************************************/
 
	UPDATE F
	SET
		QTDE_MEDIAF =0,
		QT_VD_ATUAL=0,
		QT_VD_MES1 =0,
		QT_VD_MES2 =0,
		QT_VD_MES3 =0,
		DT_CAD		=GETDATE(),
		DT_ULT_ALT	=GETDATE()
	FROM
		 EST_PROD_CPL_MEDIAF F
		 LEFT JOIN EST_PROD_CPL_NASC N ON F.CD_EMP = N.CD_EMP
										  AND F.CD_FILIAL = N.CD_FILIAL
										  AND F.CD_PROD = N.CD_PROD
		 JOIN EST_PROD_CPL_MEDIAP P ON F.CD_EMP = P.CD_EMP
									   AND F.CD_FILIAL = P.CD_FILIAL
									   AND F.CD_PROD = P.CD_PROD
	WHERE F.QTDE_MEDIAF > 0
		  AND F.CD_EMP = 1
		  AND P.QTDE_MEDIAP = 0
		  AND N.CD_EMP IS NULL
		  AND NOT F.CD_FILIAL IN(SELECT CD_FILIAL FROM PRC_FILIAL_DEPOSITO)
		  AND F.CD_FILIAL = @CD_FILIAL;
		   

/***********************************************************************************************************************************************/


		 PRINT 'INSERT 3 '+CONVERT(VARCHAR, GETDATE(), 108);
		 INSERT INTO #RS_PROD_P
		 SELECT
				np.CD_EMP
			  , np.CD_FILIAL
			  , np.CD_PROD
			  , np.QTDE_MEDIAP
			  , n.DT_NASC
			  , ISNULL(n.QTDE_MES_VENDA_FECHADO,0)
			  , ISNULL(n.DIAS_NASC,0)
			  , arv.p1
			  , arv.p2
			  , arv.ppv
			  , arv.CD_GRP_PARAM
			  , arv.TP_GRUPO_PARAMETRO
		 FROM
			 EST_PROD_CPL_MEDIAP np
			 LEFT JOIN EST_PROD_CPL_NASC n ON np.CD_EMP = n.CD_EMP
											   AND np.CD_FILIAL = n.CD_FILIAL
											   AND np.CD_PROD = n.CD_PROD
			 INNER JOIN V_EST_PROD_EST_ARV_MERCADOLOGICA arv ON np.CD_EMP = arv.CD_EMP
																AND np.CD_FILIAL = arv.CD_FILIAL
																AND np.CD_PROD = arv.CD_PROD
		 WHERE  NP.CD_EMP = @CD_EMP
				AND NP.CD_FILIAL = @CD_FILIAL
				AND ISNULL(N.MEDIA_F_LIBERADA,0) = 0
				AND ISNULL(n.QTDE_MES_VENDA_FECHADO,0) < 3
			 	AND (ARV.FREAV_MEDIAF_ULT_ATU IS NULL OR ISNULL(ARV.PROXIMO_RECALC,@AGORA) <= @AGORA) ;


/***********************************************************************************************************************************************/
		--select @ANO_MES1  'QT_IT_MES1' , @ANO_MES2  'QT_IT_MES2', @ANO_MES3  'QT_IT_MES3'
		--select * from #RS_PROD_P where  CD_PROD= 68669;
		IF OBJECT_ID('tempdb..##TmpTblVendaAtu', 'U') IS NOT NULL
			DROP TABLE ##TmpTblVendaAtu

		Create Table ##TmpTblVendaAtu(CD_PROD INT, 
									QT_IT MONEY)
		IF OBJECT_ID('tempdb..#TmpTblVenda', 'U') IS NOT NULL
			DROP TABLE #TmpTblVenda

		Create Table #TmpTblVenda(CD_PROD INT,
									ANO_MES VARCHAR(12),
									QT_IT MONEY)

		CREATE NONCLUSTERED INDEX IX_#RS_PROD_P_DT_NASC ON #RS_PROD_P([CD_EMP],[CD_FILIAL])INCLUDE ([DT_NASC]) ;

		Declare @SqlCmd as Varchar(max);
		--Efetuar os calculos e registrar na tabela temporaria
		 PRINT 'INSERT 4 '+CONVERT(VARCHAR, GETDATE(), 108);
		 
		Set @SqlCmd ='INSERT INTO ##TmpTblVendaAtu
		SELECT 
			i.CD_PROD 
			,  (case when I.dt_vd < np.DT_NASC THEN  0
					ELSE i.QT_IT END) AS QT_IT
		FROM
			PDV_VD v
			INNER JOIN PDV_VD_IT i ON v.CD_VD = i.CD_VD
									AND v.CD_FILIAL = i.CD_FILIAL
									AND v.CD_EMP	= i.CD_EMP
									AND v.DT_VD		= i.DT_VD
			INNER JOIN #RS_PROD_P np ON i.CD_EMP = np.CD_EMP
										AND i.CD_FILIAL = np.CD_FILIAL
										AND i.CD_PROD = np.CD_PROD
		WHERE   i.DT_VD BETWEEN ''' + convert(varchar, @DT_INI,112) + ''' AND ''' + convert(varchar,@DT_FIM,112) + ''' 
				AND v.ST_VD = 0 AND i.ST_IT = 1 AND I.CD_EMP = ' + convert(varchar,@CD_EMP)
				+ ' AND I.CD_FILIAL = ' + convert(varchar,@CD_FILIAL) + ' ;'
		Exec(@SqlCmd)
		PRINT 'INSERT 4.1 '+CONVERT(VARCHAR, GETDATE(), 108);

		INSERT INTO #TmpTblVenda
		SELECT 
			CD_PROD
			,'QT_IT_ATUAL' AS ANO_MES
			,SUM(QT_IT)
		from 
			##TmpTblVendaAtu
			Group by CD_PROD

		INSERT INTO #TmpTblVenda
		SELECT 
			np.CD_PROD
			, CASE((a.ano * 100) + a.mes)
					WHEN @ANO_MES1 THEN 'QT_IT_MES1'
					WHEN @ANO_MES2 THEN 'QT_IT_MES2'
					WHEN @ANO_MES3 THEN 'QT_IT_MES3'
				END
			, SUM(ISNULL(A.QT_VD, 0)) AS QT_IT
		FROM
			EST_PROD_CPL_VD a
			RIGHT JOIN #RS_PROD_P np ON a.CD_EMP = np.CD_EMP
										AND a.CD_FILIAL = np.CD_FILIAL
										AND a.CD_PROD = np.CD_PROD
										AND (a.ano * 100) + a.mes BETWEEN @ANO_MES3 AND @ANO_MES1
		WHERE  a.CD_EMP = @CD_EMP
				AND a.CD_FILIAL = @CD_FILIAL
		GROUP BY
				 np.CD_PROD
				, a.ano
				, a.mes
		
		PRINT 'INSERT 4.2 '+CONVERT(VARCHAR, GETDATE(), 108); 
		INSERT INTO #TmpTblVenda					 
		SELECT  
			 np.CD_PROD
			, 'QT_IT_PROJ'						 
			, SUM( Round(((30-DIAS_NASC)*QTDE_MEDIAP/30.000),2)) AS QT_IT
		FROM
			#RS_PROD_P np 
		WHERE  
			np.dias_nasc <30
		GROUP BY np.CD_PROD   
					  
		INSERT INTO         #RS_PROD(
					 CD_FILIAL
				   , CD_PROD
				   , P1
				   , P2
				   , PPV
				   , MEDIAP
				   , QT_IT_ATUAL
				   , QT_IT_MES1
				   , QT_IT_MES2
				   , QT_IT_MES3
				   , QT_IT_ATUAL_GRV
				   , QT_IT_MES1_GRV
				   , QT_IT_MES2_GRV
				   , QT_IT_MES3_GRV
				   , MEDIA3M
				   , SAZ
				   , DT_NASC
				   , QTDE_MES_VENDA_FECHADO)
			  SELECT
					 @CD_FILIAL
				   , MOV.CD_PROD
				   , np.P1
				   , np.P2
				   , np.PPV
				   , np.QTDE_MEDIAP					
				   , CASE WHEN @INICIO_MEDIAP_IMEDIATO =1  THEN mov.QT_IT_ATUAL
						WHEN DIAS_NASC <= 15 THEN  np.QTDE_MEDIAP --Menor que 15 então passa o controle para a média prevista
						WHEN DIAS_NASC > 15 THEN mov.QT_IT_ATUAL +  mov.QT_IT_PROJ
						ELSE 0
					 END QT_IT_ATUAL

				   ,CASE WHEN QTDE_MES_VENDA_FECHADO > 0 THEN MOV.QT_IT_MES1 -- já tem pelo menos 1 mes que nasceu (QTDE_MES_VENDA_FECHADO = qtMesesNascido - 1)
						 ELSE np.QTDE_MEDIAP
					 END QT_IT_MES1

				   , CASE WHEN QTDE_MES_VENDA_FECHADO > 1 THEN MOV.QT_IT_MES2 -- já tem pelo menos 2 meses que nasceu (QTDE_MES_VENDA_FECHADO = qtMesesNascido - 1)
						 ELSE np.QTDE_MEDIAP
					 END QT_IT_MES2

				   , CASE WHEN QTDE_MES_VENDA_FECHADO >= 2 AND MOV.QT_IT_MES3 > 0 THEN MOV.QT_IT_MES3 -- já tem 3 meses que nasceu, mas ainda não liberou a MediaF (libera quando completa 4 meses) -> (QTDE_MES_VENDA_FECHADO = qtMesesNascido - 1)
						 ELSE np.QTDE_MEDIAP
					 END QT_IT_MES3
				   -- np.QTDE_MEDIAP AS QT_IT_MES3
				   
				   , CASE WHEN DIAS_NASC <= 15 THEN --Menor que 15 então passa o controle para a média prevista
							np.QTDE_MEDIAP
						 WHEN DIAS_NASC > 15 THEN MOV.QT_IT_ATUAL
						 ELSE 0
					 END QT_IT_ATUAL
				   , CASE WHEN QTDE_MES_VENDA_FECHADO > 0 THEN MOV.QT_IT_MES1
						 ELSE np.QTDE_MEDIAP
					 END QT_IT_MES1
				   , CASE
						 WHEN QTDE_MES_VENDA_FECHADO > 1 THEN MOV.QT_IT_MES2
						 ELSE np.QTDE_MEDIAP
					 END QT_IT_MES2
				   , np.QTDE_MEDIAP AS QT_IT_MES3
				   , 0 MEDIA3M
				   , QT_IT_MES1
				   , np.DT_NASC
				   , np.QTDE_MES_VENDA_FECHADO
			  FROM
					(
						SELECT
							 CD_PROD
							 , ISNULL([QT_IT_ATUAL], 0) AS QT_IT_ATUAL
							 , ISNULL([QT_IT_MES1], 0)  AS QT_IT_MES1
							 , ISNULL([QT_IT_MES2], 0)  AS QT_IT_MES2
							 , ISNULL([QT_IT_MES3], 0)  AS QT_IT_MES3
							 , ISNULL([QT_IT_PROJ], 0)  AS QT_IT_PROJ							 
						FROM
							#TmpTblVenda PIVOT(SUM(QT_IT) FOR ANO_MES IN(
																 [QT_IT_ATUAL]
															   , [QT_IT_MES1]
															   , [QT_IT_MES2]
															   , [QT_IT_MES3]
															   , [QT_IT_PROJ] )) AS pvt
					) MOV
					INNER JOIN #RS_PROD_P np ON
						MOV.CD_PROD = np.CD_PROD;

--select * from #RS_PROD  where CD_PROD=68669 

		 PRINT 'INSERT 5 '+CONVERT(VARCHAR, GETDATE(), 108);
		 INSERT INTO         #RS_PROD(CD_FILIAL , CD_PROD , P1 , P2 , PPV
									  , MEDIAP , QT_IT_ATUAL , QT_IT_MES1 , QT_IT_MES2
									  , QT_IT_MES3 , QT_IT_ATUAL_GRV , QT_IT_MES1_GRV , QT_IT_MES2_GRV
									  , QT_IT_MES3_GRV , MEDIA3M , SAZ , DT_NASC , QTDE_MES_VENDA_FECHADO)
		 SELECT
				np.CD_FILIAL
			  , np.CD_PROD
			  , np.P1
			  , np.P2
			  , np.PPV
			  , np.QTDE_MEDIAP
			  , CASE  
					WHEN DIAS_NASC <= 15 THEN np.QTDE_MEDIAP
					ELSE 0
				END QT_IT_ATUAL
			  , CASE
					WHEN QTDE_MES_VENDA_FECHADO > 0 THEN 0
					ELSE np.QTDE_MEDIAP
				END QT_IT_MES1
			  , CASE
					WHEN QTDE_MES_VENDA_FECHADO > 1 THEN 0
					ELSE np.QTDE_MEDIAP
				END QT_IT_MES2
			  , np.QTDE_MEDIAP AS QT_IT_MES3
			  , CASE
					WHEN DIAS_NASC <= 15 THEN --Menor que 15 então passa o controle para a média prevista
								  np.QTDE_MEDIAP
					ELSE 0
				END QT_IT_ATUAL
			  , CASE
					WHEN DIAS_NASC <= 30 THEN np.QTDE_MEDIAP
					ELSE 0
				END QT_IT_MES1
			  , CASE
					WHEN DIAS_NASC > 30
						 AND QTDE_MES_VENDA_FECHADO = 1 THEN 0
					ELSE np.QTDE_MEDIAP
				END QT_IT_MES2
			  , np.QTDE_MEDIAP AS QT_IT_MES3
			  , 0 MEDIA3M
			  , 0
			  , np.DT_NASC
			  , np.QTDE_MES_VENDA_FECHADO
		 FROM
			 #RS_PROD_P np
		 WHERE  NOT EXISTS(SELECT *
								FROM
									#RS_PROD r
								WHERE  np.CD_FILIAL = r.CD_FILIAL
									   AND np.CD_PROD = r.CD_PROD);

/********************************************************************************************************/
--Fazendo a media 3M	
/********************************************************************************************************/

		 PRINT 'UPDATE 6 '+CONVERT(VARCHAR, GETDATE(), 108);
		 UPDATE P
		   SET
			   MEDIA3M = (p.QT_IT_ATUAL * (p.P1 / 100.0000)) + (((p.QT_IT_MES1 + p.QT_IT_MES2 + p.QT_IT_MES3) / 3.0000) * (p.P2 / 100.0000))
		 FROM   #RS_PROD p;
	
/********************************************************************************************************/
-- sazonalidade
/********************************************************************************************************/

--Testando se algum dos produtos calculados esta no periodo de sazonalidade (alta temporada), pois os parametros 
	 --P1 e P2 so diferenciados
		 PRINT 'UPDATE 7 '+CONVERT(VARCHAR, GETDATE(), 108);
		 UPDATE #RS_PROD
		   SET
			   P1 = P1_SAZ
			 , P2 = P2_SAZ
			 , SAZ = 1
			 , MEDIA3M = (p.QT_IT_ATUAL * (arv.P1_SAZ / 100.0000)) + (((p.QT_IT_MES1 + p.QT_IT_MES2 + p.QT_IT_MES3) / 3.0000) * (arv.P2_SAZ / 100.0000))
		 FROM   EST_PROD_SAZONALIDADE saz
				INNER JOIN V_EST_PROD_EST_ARV_MERCADOLOGICA arv ON saz.CD_EMP = arv.CD_EMP
																   AND saz.CD_PROD = arv.CD_PROD
				INNER JOIN #RS_PROD p ON p.CD_FILIAL = arv.CD_FILIAL
										 AND p.CD_PROD = arv.CD_PROD
		 WHERE
			   saz.CD_EMP = @CD_EMP
			   AND saz.MES_SAZONALIDADE = MONTH(@AGORA);
/***********************************************************************************************************************************************/
/***********************************************************************************************************************************************/
--Analisar valores fora dos limites
/***********************************************************************************************************************************************/

		 PRINT 'UPDATE 8 '+CONVERT(VARCHAR, GETDATE(), 108);
		 UPDATE #RS_PROD
		   SET
			   QT_IT_ATUAL = CASE
								 WHEN QT_IT_ATUAL > LIMITP THEN LIMITP --ANALISE DE PICO
								 WHEN QT_IT_ATUAL < LIMITV THEN LIMITV --ANALISE DE VALES
								 ELSE QT_IT_ATUAL
							 END
			 , QT_IT_MES1 = CASE
								WHEN QT_IT_MES1 > LIMITP THEN LIMITP --ANALISE DE PICO
								WHEN QT_IT_MES1 < LIMITV THEN LIMITV --ANALISE DE VALES
								ELSE QT_IT_MES1
							END
			 , QT_IT_MES2 = CASE
								WHEN QT_IT_MES2 > LIMITP THEN LIMITP --ANALISE DE PICO
								WHEN QT_IT_MES2 < LIMITV THEN LIMITV --ANALISE DE VALES
								ELSE QT_IT_MES2
							END
			 , QT_IT_MES3 = CASE
								WHEN QT_IT_MES3 > LIMITP THEN LIMITP --ANALISE DE PICO
								WHEN QT_IT_MES3 < LIMITV THEN LIMITV --ANALISE DE VALES
								ELSE QT_IT_MES3
							END
			 , QT_IT_ATUAL_GRV = CASE
									 WHEN QT_IT_ATUAL > LIMITP THEN LIMITP --ANALISE DE PICO
									 WHEN QT_IT_ATUAL < LIMITV THEN LIMITV --ANALISE DE VALES
									 ELSE QT_IT_ATUAL
								 END
			 , QT_IT_MES1_GRV = CASE
									WHEN QT_IT_MES1 > LIMITP THEN LIMITP --ANALISE DE PICO
									WHEN QT_IT_MES1 < LIMITV THEN LIMITV --ANALISE DE VALES
									ELSE QT_IT_MES1
								END
			 , QT_IT_MES2_GRV = CASE
									WHEN QT_IT_MES2 > LIMITP THEN LIMITP --ANALISE DE PICO
									WHEN QT_IT_MES2 < LIMITV THEN LIMITV --ANALISE DE VALES
									ELSE QT_IT_MES2
								END
			 , QT_IT_MES3_GRV = CASE
									WHEN QT_IT_MES3 > LIMITP THEN LIMITP --ANALISE DE PICO
									WHEN QT_IT_MES3 < LIMITV THEN LIMITV --ANALISE DE VALES
									ELSE QT_IT_MES3
								END
			  WHERE CD_FILIAL = @CD_FILIAL;
			   
/***********************************************************************************************************************************************/


		IF @CONSULTA = 0
		BEGIN
	
			IF EXISTS(SELECT TOP 1 * FROM #RS_PROD)
			BEGIN		
			PRINT 'Gerando cabecalho demanda proc ' + convert(varchar,getdate(), 108); 
				--Gerando cabecalho 
				INSERT INTO  EST_PROD_CPL_DEMANDA_PROC(
					   DT_CAD
					 , DT_CAD_REGISTRO
					 , CD_USU
					 , TP_DEMANDA
					 , DT_PROC
					 , STS_PROC
					 , ORIGEM_DEMANDA)
				SELECT
					   CONVERT(CHAR(10), GETDATE(), 112)
					 , GETDATE()
					 , 1
					 , 0
					 , CONVERT(CHAR(10), GETDATE(), 112)
					 , 0
					 , 0;

				--------------------------------------------------------------------------------------------------------------------------
				PRINT 'Gerou cabecalho demanda proc ' + convert(varchar,getdate(), 108); 
				
				INSERT INTO  EST_PROD_CPL_DEMANDA_PROC_CPL(
					   CD_CTR_DEMANDA_PROC
					 , CD_EMP
					 , CD_FILIAL
					 , CD_PROD
					 , QTDE_DEMANDA
					 , QT_VD_ATUAL
					 , QT_VD_MES1
					 , QT_VD_MES2
					 , QT_VD_MES3
					 , LIMITP
					 , LIMITV
					 , SAZ
					 , DT_NASC
					 , STS_PROD
					 , QTDE_DEMANDA_ANTERIOR
					 , CD_SIGLA
					 , CD_SIGLA_ANTERIOR)
				SELECT
					   SCOPE_IDENTITY()
					 , @CD_EMP AS CD_EMP
					 , R.CD_FILIAL
					 , R.CD_PROD
					 , CASE
						   WHEN ROUND((R.QT_IT_ATUAL * (R.P1 / 100.0000)) + (((R.QT_IT_MES1 + R.QT_IT_MES2 + R.QT_IT_MES3) / 3.0000) * (R.P2 / 100.0000)), 4) > 0 THEN ROUND((R.QT_IT_ATUAL * (R.P1 / 100.0000)) + (((R.QT_IT_MES1 + R.QT_IT_MES2 + R.QT_IT_MES3) / 3.0000) * (R.P2 / 100.0000)), 4)
						   ELSE 0
					   END AS MEDIAF
					 , CONVERT(MONEY, R.QT_IT_ATUAL_GRV)
					 , CONVERT(MONEY, R.QT_IT_MES1_GRV)
					 , CONVERT(MONEY, R.QT_IT_MES2_GRV)
					 , CONVERT(MONEY, R.QT_IT_MES3_GRV)
					 , R.LIMITP
					 , R.LIMITV
					 , R.SAZ
					 , R.DT_NASC
					 , 0 STS_PROD
					 , 0--ISNULL(EST_PROD_CPL.MEDIAF, 0)
					 , Cv.Curva
					 , 0--ISNULL(EST_PROD_CPL.CD_SIGLA, 0)
				FROM
					#RS_PROD r
					--INNER JOIN EST_PROD_CPL ON @CD_EMP = EST_PROD_CPL.CD_EMP
					--								  AND R.CD_FILIAL = EST_PROD_CPL.CD_FILIAL
					--								  AND R.CD_PROD = EST_PROD_CPL.CD_PROD
					CROSS APPLY (SELECT ISNULL((SELECT TOP (1) CD_SIGLA
									FROM
										V_EST_ARV_MD_F_GRP_PARAM_CURVA_PRC_FILIAL a
									WHERE  a.CD_EMP = @CD_EMP
											AND a.VLR_PARAMETRO <= CASE
																		WHEN ROUND((R.QT_IT_ATUAL * (R.P1 / 100.0000)) + (((R.QT_IT_MES1 + R.QT_IT_MES2 + R.QT_IT_MES3) / 3.0000) * (R.P2 / 100.0000)), 4) > 0 THEN ROUND((R.QT_IT_ATUAL * (R.P1 / 100.0000)) + (((R.QT_IT_MES1 + R.QT_IT_MES2 + R.QT_IT_MES3) / 3.0000) * (R.P2 / 100.0000)), 4)
																		ELSE 0
																	END
											AND a.CD_FILIAL = R.CD_FILIAL
																	--Modelo antigo da view
																	--AND a.CD_ARV_MERC_LINHA = R.CD_ARV_MERC_LINHA 
											AND a.CD_PROD = R.CD_PROD
									ORDER BY
												VLR_PARAMETRO DESC
									), @CD_CURVA_PD) Curva
								)Cv;
								
-- Tag #A001								
				PRINT ' Insere os parametros alterados ' + convert(varchar,getdate(), 108); 
				DELETE FROM EST_PARAM_COMPRAS_GRUPO_TMP_PARAM_ATUALIZADO
				 WHERE CD_EMP   = @CD_EMP
				   AND CD_FILIAL = @CD_FILIAL	; 
				   
				   
				   
				-- Insere os parametros alterados para atualizar na rotina de calc. de mediaf.
				INSERT INTO EST_PARAM_COMPRAS_GRUPO_TMP_PARAM_ATUALIZADO( CD_EMP,CD_GRP_PARAM,CD_FILIAL,TP_GRUPO_PARAMETRO,DT_CAD) 
				SELECT DISTINCT 
					CD_EMP
					,CD_GRP_PARAM
					,CD_FILIAL
					,TP_GRUPO_PARAMETRO
					,GETDATE() DT_CAD				
				FROM #RS_PROD_P 
				 
			end;
		 END;

/***********************************************************************************************************************************************/

		 IF @CONSULTA = 1
			 BEGIN
				 SELECT
						*
					  , (QT_IT_ATUAL * (P1 / 100.0000))
					  , ((QT_IT_MES1 + QT_IT_MES2 + QT_IT_MES3) / 3.0000) * (P2 / 100.0000)
					  , ROUND((QT_IT_ATUAL * (P1 / 100.0000)) + (((QT_IT_MES1 + QT_IT_MES2 + QT_IT_MES3) / 3.0000) * (P2 / 100.0000)), 4) AS MEDIAF
				 FROM
					 #RS_PROD  ;
			 END;

	 
		 PRINT 'P_MEDIAF_CALCULAR_LANCAMENTOS_FILIAL FINALIZADA!' + convert(varchar,getdate(), 108);;

	 END;